/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.measures;

import java.util.UUID;
import mod.chiselsandbits.api.measuring.IMeasurement;
import mod.chiselsandbits.api.measuring.MeasuringMode;
import mod.chiselsandbits.api.util.IPacketBufferSerializable;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class Measurement
implements IMeasurement,
IPacketBufferSerializable {
    private UUID owner;
    private Vec3 from;
    private Vec3 to;
    private MeasuringMode mode;
    private ResourceLocation worldKey;

    public Measurement(UUID owner, Vec3 from, Vec3 to, Direction hitFace, MeasuringMode mode, ResourceLocation worldKey) {
        this.owner = owner;
        this.mode = mode;
        this.worldKey = worldKey;
        this.adaptPositions(from, to, hitFace, mode);
    }

    public Measurement() {
    }

    private void adaptPositions(Vec3 from, Vec3 to, Direction hitFace, MeasuringMode mode) {
        this.from = mode.getType().isNeedsNormalization() ? new Vec3(Math.min(from.m_7096_(), to.m_7096_()), Math.min(from.m_7098_(), to.m_7098_()), Math.min(from.m_7094_(), to.m_7094_())) : from;
        this.to = mode.getType().isNeedsNormalization() ? new Vec3(Math.max(from.m_7096_(), to.m_7096_()), Math.max(from.m_7098_(), to.m_7098_()), Math.max(from.m_7094_(), to.m_7094_())) : to;
        this.from = mode.getType().adaptStartCorner(this.from, this.to, hitFace);
        this.to = mode.getType().adaptEndCorner(this.from, this.to, hitFace);
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public Vec3 getFrom() {
        return this.from;
    }

    @Override
    public Vec3 getTo() {
        return this.to;
    }

    @Override
    public MeasuringMode getMode() {
        return this.mode;
    }

    @Override
    public ResourceLocation getWorldKey() {
        return this.worldKey;
    }

    @Override
    public void serializeInto(@NotNull FriendlyByteBuf packetBuffer) {
        packetBuffer.m_130077_(this.getOwner());
        packetBuffer.writeDouble(this.getFrom().m_7096_());
        packetBuffer.writeDouble(this.getFrom().m_7098_());
        packetBuffer.writeDouble(this.getFrom().m_7094_());
        packetBuffer.writeDouble(this.getTo().m_7096_());
        packetBuffer.writeDouble(this.getTo().m_7098_());
        packetBuffer.writeDouble(this.getTo().m_7094_());
        packetBuffer.m_130130_(this.mode.ordinal());
        packetBuffer.m_130072_(this.getWorldKey().toString(), 0x1FFFFFFF);
    }

    @Override
    public void deserializeFrom(@NotNull FriendlyByteBuf packetBuffer) {
        this.owner = packetBuffer.m_130259_();
        this.from = new Vec3(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.to = new Vec3(packetBuffer.readDouble(), packetBuffer.readDouble(), packetBuffer.readDouble());
        this.mode = MeasuringMode.values()[packetBuffer.m_130242_()];
        this.worldKey = new ResourceLocation(packetBuffer.m_130136_(0x1FFFFFFF));
    }
}

